#include "pkcs11_wrapper.h"



pkcs11_wrapper::pkcs11_wrapper(void)
{
	m_hLibModule = NULL_PTR;
}

pkcs11_wrapper::~pkcs11_wrapper(void)
{
}


long pkcs11_wrapper::pkcs11_initialize(char * libName) 
{
	CK_RV result;

	if (m_hLibModule != 0)
		return CKR_OK;

	m_hLibModule = LoadLibrary(libName);
	if(m_hLibModule == 0)
		return CKR_GENERAL_ERROR;

	
	CK_C_GetFunctionList GetFunctionList = (CK_C_GetFunctionList)GetProcAddress(m_hLibModule,"C_GetFunctionList");
	result = GetFunctionList(&m_pFunctions);
	if (result != CKR_OK)
		return result;
	

	result = m_pFunctions->C_Initialize(NULL_PTR);
	if (result != CKR_OK && result != CKR_CRYPTOKI_ALREADY_INITIALIZED)
	{
		FreeLibrary(m_hLibModule);
		m_hLibModule = 0;
		return result;
	}

	return 0;
}

long pkcs11_wrapper::pkcs11_finalize()
{
	m_pFunctions->C_Finalize(NULL);
	return 0;
}
